/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class VWDescriptionDialog
extends VWModalDialog
implements ActionListener {
    private JTextArea m_descriptionTextArea = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;

    public VWDescriptionDialog(VWSessionInfo sessionInfo, String stringValue, String accessibilityText) {
        super(sessionInfo.getParentFrame());
        try {
            Dimension dim = VWStringUtils.stringToDimension("365,225");
            if (dim != null) {
                this.setSize(dim);
            } else {
                this.setSize(new Dimension(325, 200));
            }
            this.setTitle(VWResource.s_editDescriptionDialogTitle);
            this.createControls(stringValue, accessibilityText);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source.equals(this.m_okButton)) {
                this.m_nExitStatus = 0;
                this.setVisible(false);
            } else if (source.equals(this.m_cancelButton)) {
                this.m_nExitStatus = 1;
                this.setVisible(false);
            } else if (source.equals(this.m_helpButton)) {
                VWHelp.displayPage(VWHelp.Help_General + "bpfwd048.htm");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected String getStringValue() {
        if (this.m_descriptionTextArea != null) {
            return this.m_descriptionTextArea.getText();
        }
        return null;
    }

    protected void releaseResources() {
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this);
            this.m_okButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton = null;
        }
    }

    private void createControls(String stringValue, String accessibilityText) {
        try {
            this.getContentPane().setLayout(new BorderLayout(6, 6));
            this.getContentPane().add((Component)this.getMainPanel(stringValue, accessibilityText), "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getMainPanel(String stringValue, String accessibilityText) {
        try {
            JPanel mainPanel = new JPanel(new BorderLayout(6, 6));
            mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            if (accessibilityText == null || accessibilityText.length() == 0) {
                accessibilityText = VWResource.s_description;
            }
            VWToolbarBorder descriptionToolBar = new VWToolbarBorder(accessibilityText);
            VWAccessibilityHelper.setAccessibility(descriptionToolBar, this, accessibilityText, accessibilityText);
            JPanel childPanel = descriptionToolBar.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_descriptionTextArea = new JTextArea(stringValue);
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.setRows(5);
            VWAccessibilityHelper.setAccessibility(this.m_descriptionTextArea, this, accessibilityText, accessibilityText);
            VWAccessibilityHelper.setLabelFor(new JLabel(accessibilityText), this.m_descriptionTextArea);
            childPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), "Center");
            mainPanel.add((Component)descriptionToolBar, "Center");
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new FlowLayout());
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.addActionListener(this);
            buttonPanel.add(this.m_okButton);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            buttonPanel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            buttonPanel.add(this.m_helpButton);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

